var gPeople = new Array()

///////////////////////////////////////////////////////////////////////////////////////////////

function GetPlayer()
{
	for (var i = 0; i < gPeople.length; i++)
		{
			if (gPeople[i].name == "player") return i
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function PersonNameToNumber(name)
{
	for (var i = 0; i < gPeople.length; i++)
		{
			if (gPeople[i].name == name) return i
		}
		
		return -1 
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ProcPeople()
{
	
	for (var i = 0; i < gPeople.length; i++)
		{
		
			gPeople[i].onUpdate();
		
			var name = gPeople[i].name
			var x = GetPersonX(name);
			var y = GetPersonY(name);
			var layer = GetPersonLayer(name);
			
			///////////////////////////////////////////////////////////////////////////////////////////////	

			if (gPeople[i].move != -1)
				{
					switch (gPeople[i].move)
						{
							case 0:
								if (!Obstruction(i, x, y-gPeople[i].speed))
									{
										SetPersonY(name, y-gPeople[i].speed)
										gPeople[i].move_dist+=gPeople[i].speed
										
										if (gPeople[i].move_dist >= GetTileHeight())
											{
												gPeople[i].move_dist = 0;
												gPeople[i].move = -1;
											}
									}
								else
									{
										PersonObstructCheck(i, x, y-gPeople[i].speed)
										gPeople[i].move_dist = 0;
										gPeople[i].move = -1;									
									}									
								SetPersonDirection(name, "NORTH")
							break; case 1:
								if (!Obstruction(i, x, y+gPeople[i].speed))
									{
										SetPersonY(name, y+gPeople[i].speed)
										gPeople[i].move_dist+=gPeople[i].speed
										
										if (gPeople[i].move_dist >= GetTileHeight())
											{
												gPeople[i].move_dist = 0;
												gPeople[i].move = -1;
											}
									}						
								else
									{
										PersonObstructCheck(i, x, y+gPeople[i].speed)
										gPeople[i].move_dist = 0;
										gPeople[i].move = -1;									
									}										
								SetPersonDirection(name, "SOUTH")
							break; case 2:
								if (!Obstruction(i, x-gPeople[i].speed, y))
									{
										SetPersonX(name, x-gPeople[i].speed)
										gPeople[i].move_dist+=gPeople[i].speed
										
										if (gPeople[i].move_dist >= GetTileWidth())
											{
												gPeople[i].move_dist = 0;
												gPeople[i].move = -1;
											}
									}							
								else
									{
										PersonObstructCheck(i, x-gPeople[i].speed, y)
										gPeople[i].move_dist = 0;
										gPeople[i].move = -1;									
									}									
								SetPersonDirection(name, "WEST")
							break; case 3:
								if (!Obstruction(i, x+gPeople[i].speed, y))
									{
										SetPersonX(name, x+gPeople[i].speed)
										gPeople[i].move_dist+=gPeople[i].speed
										
										if (gPeople[i].move_dist >= GetTileWidth())
											{
												gPeople[i].move_dist = 0;
												gPeople[i].move = -1;
											}
									}											
								else
									{
										PersonObstructCheck(i, x+gPeople[i].speed, y)									
										gPeople[i].move_dist = 0;
										gPeople[i].move = -1;									
									}
								SetPersonDirection(name, "EAST")
							break;
						}
				}
				
			///////////////////////////////////////////////////////////////////////////////////////////////	
				
			x = GetPersonX(name)
			y = GetPersonY(name)

			layer = GetPersonLayer(name)

			if (IsTriggerAt(x, y, layer))
				{
					if (i == GetPlayer() )
						{
							ExecuteTrigger(x, y, layer);
							return
						}
				}
				
			if (AreZonesAt(x, y, layer))
				{
					if (i == GetPlayer() )
						{
							ExecuteZones(x, y, layer);
							//return
						}
				}				
				
			///////////////////////////////////////////////////////////////////////////////////////////////
		
			if (gPeople[i].move != -1) QueuePersonCommand(name,COMMAND_ANIMATE,true)
		}
		
		for (var i = 0; i < gPeople.length; i++)
			{	
				if (gPeople[i].dead) 
					{
						DestroyPerson(gPeople[i].name)
						gPeople.splice(i, 1)
					}
			}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function ProcInput()
{
	if (!gSuspendMovement)
		{
			n = GetPlayer()
		
			if (gPeople[n].move_dist == 0)
				{
		
					if (IsKeyPressed(k_up))
						{
							gPeople[n].move = 0
						}
				
					if (IsKeyPressed(k_down))
						{
							gPeople[n].move = 1
						}
				
					if (IsKeyPressed(k_left))
						{
							gPeople[n].move = 2
						}
				
					if (IsKeyPressed(k_right))
						{
							gPeople[n].move = 3
						}	
				
					if (IsKeyPressed(k_b))
						{
							Menu_Player_Begin()
						}
					
					if (IsKeyPressed(k_a))
						{
									
							var x = GetPersonX(gPeople[n].name)
							var y = GetPersonY(gPeople[n].name)		
								
							switch (GetPersonDirection(gPeople[n].name))
								{
									case "NORTH":
										PersonTalkCheck(n, x, y-14 )
									break; case "SOUTH":
										PersonTalkCheck(n, x, y+14 )
									break; case "EAST":
										PersonTalkCheck(n, x+14, y )
									break; case "WEST":
										PersonTalkCheck(n, x-14, y )
									break;
										
								}
						}					
				
				}
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function oPerson(name, onTouch, onTalk, onUpdate, onAction)
{
	this.name = name
	
	this.speed = 1
	this.move = -1
	this.move_dist = 0
	this.brain = []
	
	this.onTouch = onTouch
	this.onTalk = onTalk
	this.onUpdate = onUpdate
	this.onAction = onAction
	
	this.dead = false
}

///////////////////////////////////////////////////////////////////////////////////////////////

function Obstruction(person, x, y)
{
	var name = gPeople[person].name
	var layer = GetPersonLayer(name)

	if (
			!IsPersonObstructed(name, x, y) && //FOR X
			x < (GetLayerWidth(layer)*GetTileWidth())+8-16 && 
			x > 0+6 &&
			y < (GetLayerHeight(layer)*GetTileHeight() )+8-16 && 
			y > 0+6)
		{
			return false
		}
	else
		{
			return true
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function PersonObstructCheck(person, x, y)
{
	var name = gPeople[person].name
	var layer = GetPersonLayer(name)

	var obs = GetObstructingPerson(name, x, y)

	if (obs != "")
		{
			var n = PersonNameToNumber(obs)
			
			gPeople[n].onTouch(gPeople[person])
		}
		
}

///////////////////////////////////////////////////////////////////////////////////////////////

function PersonTalkCheck(person, x, y)
{

	var name = gPeople[person].name
	var layer = GetPersonLayer(name)
	
	var obs = GetObstructingPerson(name, x, y)
	
	if (obs != "")
		{
			var n = PersonNameToNumber(obs)
			
			gPeople[n].onTalk(gPeople[person])
		}
		
}

///////////////////////////////////////////////////////////////////////////////////////////////

function AddPerson()
{
	gPeople.push( new oPerson(GetCurrentPerson(), DoNothing, DoNothing, DoNothing, DoNothing) )
	AttachCamera(GetCurrentPerson())
}

///////////////////////////////////////////////////////////////////////////////////////////////

function SwapWalkMap(map, x, y)
{

	UProcList = new Array()
	RProcList = new Array()
	gPeople = new Array()

	UProcList.push(UpdateMenus)
	RProcList.push(RenderMenus)			
	
	UProcList.push(ProcPeople)
	UProcList.push(ProcInput)
	
	ChangeMap(map)  
	
	if (x != -1) AddPlayerWalk(x,y)
	else
		{
			CreatePerson("player", PLAYER_WALK_SPRITE, true)
			
			gPeople.push( new oPerson("player", DoNothing, DoNothing, DoNothing, DoNothing) )		
			AttachCamera("player")	
		}
}

///////////////////////////////////////////////////////////////////////////////////////////////

function AddPlayerWalk(x, y)
{
	if (gFlags[10] == true) PLAYER_WALK_SPRITE = "blackfoot2.rss"

	CreatePerson("player", PLAYER_WALK_SPRITE, true)
	
	gPeople.push( new oPerson("player", DoNothing, DoNothing, DoNothing, DoNothing) )		
	
	SetPersonX("player", (x * 16) + 7) 
	SetPersonY("player", (y * 16) + 7)
	
	AttachCamera("player")
}